library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity test_7segInterfaceDEC is

	port
	(
		clk		  	: in std_logic;
		reset			: in std_logic;
	
		x				: out std_logic_vector(3 downto 0);
		enable		: out std_logic;
		
		a				: in std_logic;
		b				: in std_logic;
		c				: in std_logic;
		d				: in std_logic;
		e				: in std_logic;
		f				: in std_logic;
		g				: in std_logic;
						
		
		ok				: out std_logic
	);

end entity;

architecture rtl of test_7segInterfaceDEC is
	signal   cnt: integer range 0 to 31:=0;
	signal   cnt_next: integer range 0 to 31:=0;
	signal	x_out:std_logic_vector(3 downto 0):= (others=>'0');
	signal	enable_out:std_logic:='0';

	signal	ok_next: std_logic:='1';
	signal	ok_out: std_logic:='1';
	
	
begin

	process (clk)
	variable cnt_next:integer range 0 to 31;
	begin
	
	
	if (rising_edge(clk)) then
		if reset='1' then
			ok_out<='1';
			cnt<=0;
			cnt_next:=0;
		else
			cnt<=cnt_next;
			ok_out<=ok_out and ok_next;
			cnt_next:=cnt_next+1;
		end if;
	end if;
	end process;
	
	process (a,b,c,d,e,f,g,x_out,enable_out) 
		variable res_a,res_b,res_c,res_d,res_e,res_f,res_g:std_logic;
		variable bcat:std_logic_vector(4 downto 0);
	begin
	
		bcat := enable_out & x_out(3)& x_out(2)& x_out(1)& x_out(0);
		case bcat is
			when "10000" => res_a := '0'; res_b := '0'; res_c := '0'; res_d := '0'; res_e := '0'; res_f := '0'; res_g := '1';
			when "10001" => res_a := '1'; res_b := '0'; res_c := '0'; res_d := '1'; res_e := '1'; res_f := '1'; res_g := '1';
			when "10010" => res_a := '0'; res_b := '0'; res_c := '1'; res_d := '0'; res_e := '0'; res_f := '1'; res_g := '0';
			when "10011" => res_a := '0'; res_b := '0'; res_c := '0'; res_d := '0'; res_e := '1'; res_f := '1'; res_g := '0';
			when "10100" => res_a := '1'; res_b := '0'; res_c := '0'; res_d := '1'; res_e := '1'; res_f := '0'; res_g := '0';
			when "10101" => res_a := '0'; res_b := '1'; res_c := '0'; res_d := '0'; res_e := '1'; res_f := '0'; res_g := '0';
			when "10110" => res_a := '0'; res_b := '1'; res_c := '0'; res_d := '0'; res_e := '0'; res_f := '0'; res_g := '0';
			when "10111" => res_a := '0'; res_b := '0'; res_c := '0'; res_d := '1'; res_e := '1'; res_f := '1'; res_g := '1';
			when "11000" => res_a := '0'; res_b := '0'; res_c := '0'; res_d := '0'; res_e := '0'; res_f := '0'; res_g := '0';
			when "11001" => res_a := '0'; res_b := '0'; res_c := '0'; res_d := '0'; res_e := '1'; res_f := '0'; res_g := '0';
			when "11010" => res_a := '0'; res_b := '0'; res_c := '0'; res_d := '1'; res_e := '0'; res_f := '0'; res_g := '0';
			when "11011" => res_a := '1'; res_b := '1'; res_c := '0'; res_d := '0'; res_e := '0'; res_f := '0'; res_g := '0';
			when "11100" => res_a := '0'; res_b := '1'; res_c := '1'; res_d := '0'; res_e := '0'; res_f := '0'; res_g := '1';
			when "11101" => res_a := '1'; res_b := '0'; res_c := '0'; res_d := '0'; res_e := '0'; res_f := '1'; res_g := '0';
			when "11110" => res_a := '0'; res_b := '1'; res_c := '1'; res_d := '0'; res_e := '0'; res_f := '0'; res_g := '0';
			when "11111" => res_a := '0'; res_b := '1'; res_c := '1'; res_d := '1'; res_e := '0'; res_f := '0'; res_g := '0';
			when others  => res_a := '1'; res_b := '1'; res_c := '1'; res_d := '1'; res_e := '1'; res_f := '1'; res_g := '1';
	  end case;

	if ((res_a=a)and(res_b=b)and(res_c=c)and(res_d=d)and(res_e=e)and(res_f=f)and(res_g=g)) or (unsigned(bcat(3 downto 0))>9) then
			ok_next<='1';
			else
			ok_next<='0';
	end if;

	end process;
	
	x_out<=std_logic_vector(to_unsigned(cnt, 5))(3 downto 0);
	x<=std_logic_vector(to_unsigned(cnt, 5))(3 downto 0);
	enable_out<=std_logic_vector(to_unsigned(cnt, 5))(4);
	enable<=std_logic_vector(to_unsigned(cnt, 5))(4);
	
	ok<=ok_out;

end rtl;
